

<?php $__env->startSection('title', 'Loading Screen Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>Loading Screen Settings</h1>
        <p>Customize your server's loading screen appearance and content.</p>
    </div>


    <div class="settings-page">
        <div class="nav-tabs">
            <div class="nav-item">
                <a class="nav-link active" href="#general" data-tab="general">
                    <i class="fas fa-cog"></i> General
                </a>
            </div>
            <div class="nav-item">
                <a class="nav-link" href="#content" data-tab="content">
                    <i class="fas fa-align-left"></i> Content
                </a>
            </div>
            <div class="nav-item">
                <a class="nav-link" href="#features" data-tab="features">
                    <i class="fas fa-puzzle-piece"></i> Features
                </a>
            </div>
            <div class="nav-item">
                <a class="nav-link" href="#advanced" data-tab="advanced">
                    <i class="fas fa-code"></i> Advanced
                </a>
            </div>
        </div>

        <form action="<?php echo e(route('admin.loading-screen.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            
            <div class="tab-content">
                <!-- General Tab -->
                <div class="tab-pane active" id="general">
                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>General Settings</h3>
                            <div class="header-actions">
                                <a href="<?php echo e(route('admin.loading-screen.preview')); ?>" target="_blank" class="btn btn-primary btn-sm">
                                    <i class="fas fa-eye"></i> Preview
                                </a>
                            </div>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="logo">Server Logo</label>
                                        <div class="file-upload-wrapper">
                                            <label for="logo" class="file-upload-label">
                                                <i class="fas fa-upload file-upload-icon"></i>
                                                <span>Choose Logo (Recommended: 250x120px)</span>
                                            </label>
                                            <input type="file" name="logo" id="logo" class="file-upload-input" accept="image/*">
                                            
                                            <div class="file-upload-preview">
                                                <?php if($settings->logo): ?>
                                                <div class="current-file">
                                                    <span class="file-name">Current Logo</span>
                                                    <img src="<?php echo e(asset('storage/' . $settings->logo)); ?>" alt="Current Logo" class="file-preview">
                                                    <button type="button" class="btn btn-danger btn-sm mt-2 delete-file" data-type="logo">Remove</button>
                                                </div>
                                                <?php endif; ?>
                                                <div class="new-file" style="display:none;">
                                                    <span class="file-name">New Logo</span>
                                                    <img src="" alt="New Logo Preview" class="file-preview" id="logo-preview">
                                                </div>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="error-message"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="background_image">Background Image</label>
                                        <div class="file-upload-wrapper">
                                            <label for="background_image" class="file-upload-label">
                                                <i class="fas fa-upload file-upload-icon"></i>
                                                <span>Choose Background (Recommended: 1920x1080px)</span>
                                            </label>
                                            <input type="file" name="background_image" id="background_image" class="file-upload-input" accept="image/*">
                                            
                                            <div class="file-upload-preview">
                                                <?php if($settings->background_image): ?>
                                                <div class="current-file">
                                                    <span class="file-name">Current Background</span>
                                                    <img src="<?php echo e(asset('storage/' . $settings->background_image)); ?>" alt="Current Background" class="file-preview">
                                                    <button type="button" class="btn btn-danger btn-sm mt-2 delete-file" data-type="background_image">Remove</button>
                                                </div>
                                                <?php endif; ?>
                                                <div class="new-file" style="display:none;">
                                                    <span class="file-name">New Background</span>
                                                    <img src="" alt="New Background Preview" class="file-preview" id="background-preview">
                                                </div>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['background_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="error-message"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="background_color">Background Color</label>
                                        <div class="color-picker-wrapper">
                                            <input type="color" name="background_color" id="background_color" class="color-picker-input" value="<?php echo e($settings->background_color); ?>">
                                            <input type="text" class="form-control color-text-input" id="background_color_text" value="<?php echo e($settings->background_color); ?>">
                                        </div>
                                        <div class="form-text">Used as fallback if no background image is set.</div>
                                        <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="error-message"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="primary_color">Primary Color</label>
                                        <div class="color-picker-wrapper">
                                            <input type="color" name="primary_color" id="primary_color" class="color-picker-input" value="<?php echo e($settings->primary_color); ?>">
                                            <input type="text" class="form-control color-text-input" id="primary_color_text" value="<?php echo e($settings->primary_color); ?>">
                                        </div>
                                        <div class="form-text">Used for buttons, accents, and highlights.</div>
                                        <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="error-message"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Music Settings</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="form-check mb-4">
                                <input type="checkbox" name="enable_music" id="enable_music" class="form-check-input" <?php echo e($settings->enable_music ? 'checked' : ''); ?>>
                                <label for="enable_music" class="form-check-label">Enable Background Music</label>
                            </div>
                            
                            <div class="music-settings" <?php echo e($settings->enable_music ? '' : 'style=display:none;'); ?>>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="music_file">Music File</label>
                                            <div class="file-upload-wrapper">
                                                <label for="music_file" class="file-upload-label">
                                                    <i class="fas fa-music file-upload-icon"></i>
                                                    <span>Choose Music File (MP3, OGG, WAV)</span>
                                                </label>
                                                <input type="file" name="music_file" id="music_file" class="file-upload-input" accept=".mp3,.ogg,.wav">
                                                
                                                <div class="file-upload-preview">
                                                    <?php if($settings->music_file): ?>
                                                    <div class="current-file">
                                                        <span class="file-name">Current Music</span>
                                                        <i class="fas fa-music fa-2x"></i>
                                                        <audio controls class="mt-2" style="width: 200px;">
                                                            <source src="<?php echo e(asset('storage/' . $settings->music_file)); ?>" type="audio/mpeg">
                                                            Your browser does not support the audio element.
                                                        </audio>
                                                        <button type="button" class="btn btn-danger btn-sm mt-2 delete-file" data-type="music_file">Remove</button>
                                                    </div>
                                                    <?php endif; ?>
                                                    <div class="new-file" style="display:none;">
                                                        <span class="file-name">New Music</span>
                                                        <i class="fas fa-music fa-2x"></i>
                                                        <audio controls class="mt-2" style="width: 200px;" id="music-preview">
                                                            <source src="" type="audio/mpeg">
                                                            Your browser does not support the audio element.
                                                        </audio>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php $__errorArgs = ['music_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="error-message"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="music_volume">Default Volume (<?php echo e($settings->music_volume * 100); ?>%)</label>
                                            <input type="range" name="music_volume" id="music_volume" class="form-range" min="0" max="1" step="0.01" value="<?php echo e($settings->music_volume); ?>">
                                            <div class="form-text">Users will be able to adjust this in the loading screen.</div>
                                            <?php $__errorArgs = ['music_volume'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="error-message"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Content Tab -->
                <div class="tab-pane" id="content">
                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Server Rules</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div id="server-rules-container">
                                <?php if(is_array($settings->server_rules)): ?>
                                    <?php $__currentLoopData = $settings->server_rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group rule-item">
                                            <div class="d-flex">
                                                <input type="text" name="server_rules[]" class="form-control" value="<?php echo e($rule); ?>" placeholder="Enter a server rule">
                                                <button type="button" class="btn btn-danger ml-2 remove-rule"><i class="fas fa-times"></i></button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            
                            <button type="button" class="btn btn-secondary mt-2" id="add-rule">
                                <i class="fas fa-plus"></i> Add Rule
                            </button>
                        </div>
                    </div>

                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Loading Tips</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="form-check mb-4">
                                <input type="checkbox" name="enable_tips" id="enable_tips" class="form-check-input" <?php echo e($settings->enable_tips ? 'checked' : ''); ?>>
                                <label for="enable_tips" class="form-check-label">Show rotating tips during loading</label>
                            </div>
                            
                            <div id="tips-container" <?php echo e($settings->enable_tips ? '' : 'style=display:none;'); ?>>
                                <?php if(is_array($settings->tips)): ?>
                                    <?php $__currentLoopData = $settings->tips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group tip-item">
                                            <div class="d-flex">
                                                <input type="text" name="tips[]" class="form-control" value="<?php echo e($tip); ?>" placeholder="Enter a helpful tip">
                                                <button type="button" class="btn btn-danger ml-2 remove-tip"><i class="fas fa-times"></i></button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            
                            <button type="button" class="btn btn-secondary mt-2" id="add-tip">
                                <i class="fas fa-plus"></i> Add Tip
                            </button>
                        </div>
                    </div>

                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Community Links</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="form-check mb-4">
                                <input type="checkbox" name="enable_community_links" id="enable_community_links" class="form-check-input" <?php echo e($settings->enable_community_links ? 'checked' : ''); ?>>
                                <label for="enable_community_links" class="form-check-label">Show community links</label>
                            </div>
                            
                            <div id="community-links-container" <?php echo e($settings->enable_community_links ? '' : 'style=display:none;'); ?>>
                                <?php if(is_array($settings->community_links)): ?>
                                    <?php $__currentLoopData = $settings->community_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group community-link-item mb-3">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <input type="text" name="community_links[<?php echo e($index); ?>][name]" class="form-control" value="<?php echo e($link['name'] ?? ''); ?>" placeholder="Link Name">
                                                </div>
                                                <div class="col-md-5">
                                                    <input type="text" name="community_links[<?php echo e($index); ?>][url]" class="form-control" value="<?php echo e($link['url'] ?? ''); ?>" placeholder="URL">
                                                </div>
                                                <div class="col-md-3">
                                                    <select name="community_links[<?php echo e($index); ?>][icon]" class="form-control icon-select">
                                                        <option value="fas fa-globe" <?php echo e(($link['icon'] ?? '') == 'fas fa-globe' ? 'selected' : ''); ?>>Website</option>
                                                        <option value="fab fa-discord" <?php echo e(($link['icon'] ?? '') == 'fab fa-discord' ? 'selected' : ''); ?>>Discord</option>
                                                        <option value="fab fa-steam" <?php echo e(($link['icon'] ?? '') == 'fab fa-steam' ? 'selected' : ''); ?>>Steam</option>
                                                        <option value="fab fa-twitter" <?php echo e(($link['icon'] ?? '') == 'fab fa-twitter' ? 'selected' : ''); ?>>Twitter</option>
                                                        <option value="fab fa-youtube" <?php echo e(($link['icon'] ?? '') == 'fab fa-youtube' ? 'selected' : ''); ?>>YouTube</option>
                                                        <option value="fab fa-facebook" <?php echo e(($link['icon'] ?? '') == 'fab fa-facebook' ? 'selected' : ''); ?>>Facebook</option>
                                                        <option value="fab fa-instagram" <?php echo e(($link['icon'] ?? '') == 'fab fa-instagram' ? 'selected' : ''); ?>>Instagram</option>
                                                        <option value="fas fa-shopping-cart" <?php echo e(($link['icon'] ?? '') == 'fas fa-shopping-cart' ? 'selected' : ''); ?>>Store</option>
                                                        <option value="fas fa-comments" <?php echo e(($link['icon'] ?? '') == 'fas fa-comments' ? 'selected' : ''); ?>>Forum</option>
                                                        <option value="fas fa-donate" <?php echo e(($link['icon'] ?? '') == 'fas fa-donate' ? 'selected' : ''); ?>>Donate</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-1">
                                                    <button type="button" class="btn btn-danger remove-link"><i class="fas fa-times"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            
                            <button type="button" class="btn btn-secondary mt-2" id="add-link">
                                <i class="fas fa-plus"></i> Add Link
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Features Tab -->
                <div class="tab-pane" id="features">
                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Feature Toggles</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="feature-card" style="border-left-color: <?php echo e($settings->primary_color); ?>;">
                                        <div class="feature-icon" style="background-color: rgba(<?php echo e(hexToRgb($settings->primary_color)); ?>, 0.2); color: <?php echo e($settings->primary_color); ?>;">
                                            <i class="fas fa-spinner"></i>
                                        </div>
                                        <h3>Loading Progress Bar</h3>
                                        <p>Show a progress bar that updates as game content loads.</p>
                                        <div class="toggle-switch">
                                            <input type="checkbox" name="enable_loading_bar" id="enable_loading_bar" class="toggle-switch-checkbox" <?php echo e($settings->enable_loading_bar ? 'checked' : ''); ?>>
                                            <label for="enable_loading_bar" class="toggle-switch-label">
                                                <span class="toggle-switch-switch"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="feature-card" style="border-left-color: <?php echo e($settings->primary_color); ?>;">
                                        <div class="feature-icon" style="background-color: rgba(<?php echo e(hexToRgb($settings->primary_color)); ?>, 0.2); color: <?php echo e($settings->primary_color); ?>;">
                                            <i class="fas fa-info-circle"></i>
                                        </div>
                                        <h3>Server Information</h3>
                                        <p>Display server rules and other important information.</p>
                                        <div class="toggle-switch">
                                            <input type="checkbox" name="enable_server_info" id="enable_server_info" class="toggle-switch-checkbox" <?php echo e($settings->enable_server_info ? 'checked' : ''); ?>>
                                            <label for="enable_server_info" class="toggle-switch-label">
                                                <span class="toggle-switch-switch"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="feature-card" style="border-left-color: <?php echo e($settings->primary_color); ?>;">
                                        <div class="feature-icon" style="background-color: rgba(<?php echo e(hexToRgb($settings->primary_color)); ?>, 0.2); color: <?php echo e($settings->primary_color); ?>;">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <h3>Player Information</h3>
                                        <p>Show player's Steam avatar and name during loading.</p>
                                        <div class="toggle-switch">
                                            <input type="checkbox" name="enable_player_info" id="enable_player_info" class="toggle-switch-checkbox" <?php echo e($settings->enable_player_info ? 'checked' : ''); ?>>
                                            <label for="enable_player_info" class="toggle-switch-label">
                                                <span class="toggle-switch-switch"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="feature-card" style="border-left-color: <?php echo e($settings->primary_color); ?>;">
                                        <div class="feature-icon" style="background-color: rgba(<?php echo e(hexToRgb($settings->primary_color)); ?>, 0.2); color: <?php echo e($settings->primary_color); ?>;">
                                            <i class="fas fa-map"></i>
                                        </div>
                                        <h3>Map Information</h3>
                                        <p>Display the current map name and image.</p>
                                        <div class="toggle-switch">
                                            <input type="checkbox" name="enable_map_info" id="enable_map_info" class="toggle-switch-checkbox" <?php echo e($settings->enable_map_info ? 'checked' : ''); ?>>
                                            <label for="enable_map_info" class="toggle-switch-label">
                                                <span class="toggle-switch-switch"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Advanced Tab -->
                <div class="tab-pane" id="advanced">
                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Custom CSS</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="form-group">
                                <label for="custom_css">Add custom CSS styles</label>
                                <textarea name="custom_css" id="custom_css" class="form-control" rows="10"><?php echo e($settings->custom_css); ?></textarea>
                                <div class="form-text">Custom CSS will be included at the end of the loading screen styles.</div>
                                <?php $__errorArgs = ['custom_css'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="error-message"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Custom JavaScript</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <div class="form-group">
                                <label for="custom_js">Add custom JavaScript</label>
                                <textarea name="custom_js" id="custom_js" class="form-control" rows="10"><?php echo e($settings->custom_js); ?></textarea>
                                <div class="form-text">Custom JavaScript will be included at the end of the loading screen script.</div>
                                <?php $__errorArgs = ['custom_js'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="error-message"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="dashboard-card">
                        <div class="dashboard-card-header">
                            <h3>Reset Settings</h3>
                        </div>
                        <div class="dashboard-card-body">
                            <p>Reset all loading screen settings to their default values. This action cannot be undone.</p>
                            <button type="button" class="btn btn-danger" id="reset-settings">
                                <i class="fas fa-undo"></i> Reset to Defaults
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Changes
                </button>
                <a href="<?php echo e(route('admin.loading-screen.preview')); ?>" target="_blank" class="btn btn-secondary ml-2">
                    <i class="fas fa-eye"></i> Preview
                </a>
            </div>
        </form>

        <!-- Reset Settings Form -->
        <form id="reset-form" action="<?php echo e(route('admin.loading-screen.reset')); ?>" method="POST" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>
    </div>
</div>

<!-- Confirmation Modal -->
<div class="modal-backdrop" id="confirm-modal">
    <div class="modal">
        <div class="modal-header">
            <h3>Confirm Action</h3>
            <button type="button" class="close-btn" id="close-modal">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <p id="confirm-message">Are you sure you want to perform this action?</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" id="cancel-action">Cancel</button>
            <button type="button" class="btn btn-danger" id="confirm-action">Confirm</button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab navigation
    document.querySelectorAll('.nav-link').forEach(function(tab) {
        tab.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Hide all tab panes
            document.querySelectorAll('.tab-pane').forEach(function(pane) {
                pane.classList.remove('active');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.nav-link').forEach(function(tab) {
                tab.classList.remove('active');
            });
            
            // Show target tab pane
            const target = this.getAttribute('data-tab');
            document.getElementById(target).classList.add('active');
            
            // Add active class to clicked tab
            this.classList.add('active');
        });
    });

    // File upload preview
    function handleFileUpload(inputId, previewId) {
        const input = document.getElementById(inputId);
        const preview = document.getElementById(previewId);
        const newFileDiv = preview.closest('.new-file');
        
        input.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    newFileDiv.style.display = 'flex';
                }
                
                reader.readAsDataURL(this.files[0]);
            }
        });
    }
    
    handleFileUpload('logo', 'logo-preview');
    handleFileUpload('background_image', 'background-preview');
    
    // Music file upload preview
    const musicInput = document.getElementById('music_file');
    const musicPreview = document.getElementById('music-preview');
    const musicFileDiv = musicPreview?.closest('.new-file');
    
    if (musicInput && musicPreview && musicFileDiv) {
        musicInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    musicPreview.querySelector('source').src = e.target.result;
                    musicPreview.load();
                    musicFileDiv.style.display = 'flex';
                }
                
                reader.readAsDataURL(this.files[0]);
            }
        });
    }

    // Color pickers
    function syncColorInputs(colorInput, textInput) {
        colorInput.addEventListener('input', function() {
            textInput.value = this.value;
        });
        
        textInput.addEventListener('input', function() {
            if (/^#[0-9A-F]{6}$/i.test(this.value)) {
                colorInput.value = this.value;
            }
        });
    }
    
    syncColorInputs(
        document.getElementById('background_color'),
        document.getElementById('background_color_text')
    );
    
    syncColorInputs(
        document.getElementById('primary_color'),
        document.getElementById('primary_color_text')
    );

    // Enable/disable sections based on checkboxes
    document.getElementById('enable_music').addEventListener('change', function() {
        document.querySelector('.music-settings').style.display = this.checked ? 'block' : 'none';
    });
    
    document.getElementById('enable_tips').addEventListener('change', function() {
        document.getElementById('tips-container').style.display = this.checked ? 'block' : 'none';
    });
    
    document.getElementById('enable_community_links').addEventListener('change', function() {
        document.getElementById('community-links-container').style.display = this.checked ? 'block' : 'none';
    });

    // Server rules management
    const rulesContainer = document.getElementById('server-rules-container');
    
    document.getElementById('add-rule').addEventListener('click', function() {
        const newRule = document.createElement('div');
        newRule.className = 'form-group rule-item';
        newRule.innerHTML = `
            <div class="d-flex">
                <input type="text" name="server_rules[]" class="form-control" placeholder="Enter a server rule">
                <button type="button" class="btn btn-danger ml-2 remove-rule"><i class="fas fa-times"></i></button>
            </div>
        `;
        rulesContainer.appendChild(newRule);
        
        newRule.querySelector('.remove-rule').addEventListener('click', function() {
            rulesContainer.removeChild(newRule);
        });
    });
    
    document.querySelectorAll('.remove-rule').forEach(function(button) {
        button.addEventListener('click', function() {
            rulesContainer.removeChild(button.closest('.rule-item'));
        });
    });

    // Tips management
    const tipsContainer = document.getElementById('tips-container');
    
    document.getElementById('add-tip').addEventListener('click', function() {
        const newTip = document.createElement('div');
        newTip.className = 'form-group tip-item';
        newTip.innerHTML = `
            <div class="d-flex">
                <input type="text" name="tips[]" class="form-control" placeholder="Enter a helpful tip">
                <button type="button" class="btn btn-danger ml-2 remove-tip"><i class="fas fa-times"></i></button>
            </div>
        `;
        tipsContainer.appendChild(newTip);
        
        newTip.querySelector('.remove-tip').addEventListener('click', function() {
            tipsContainer.removeChild(newTip);
        });
    });
    
    document.querySelectorAll('.remove-tip').forEach(function(button) {
        button.addEventListener('click', function() {
            tipsContainer.removeChild(button.closest('.tip-item'));
        });
    });

    // Community links management
    const linksContainer = document.getElementById('community-links-container');
    let linkCounter = linksContainer.querySelectorAll('.community-link-item').length || 0;
    
    document.getElementById('add-link').addEventListener('click', function() {
        const newLink = document.createElement('div');
        newLink.className = 'form-group community-link-item mb-3';
        newLink.innerHTML = `
            <div class="row">
                <div class="col-md-3">
                    <input type="text" name="community_links[${linkCounter}][name]" class="form-control" placeholder="Link Name">
                </div>
                <div class="col-md-5">
                    <input type="text" name="community_links[${linkCounter}][url]" class="form-control" placeholder="URL">
                </div>
                <div class="col-md-3">
                    <select name="community_links[${linkCounter}][icon]" class="form-control icon-select">
                        <option value="fas fa-globe">Website</option>
                        <option value="fab fa-discord">Discord</option>
                        <option value="fab fa-steam">Steam</option>
                        <option value="fab fa-twitter">Twitter</option>
                        <option value="fab fa-youtube">YouTube</option>
                        <option value="fab fa-facebook">Facebook</option>
                        <option value="fab fa-instagram">Instagram</option>
                        <option value="fas fa-shopping-cart">Store</option>
                        <option value="fas fa-comments">Forum</option>
                        <option value="fas fa-donate">Donate</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-danger remove-link"><i class="fas fa-times"></i></button>
                </div>
            </div>
        `;
        linksContainer.appendChild(newLink);
        linkCounter++;
        
        newLink.querySelector('.remove-link').addEventListener('click', function() {
            linksContainer.removeChild(newLink);
        });
    });
    
    document.querySelectorAll('.remove-link').forEach(function(button) {
        button.addEventListener('click', function() {
            linksContainer.removeChild(button.closest('.community-link-item'));
        });
    });

    // Volume range display
    const volumeRange = document.getElementById('music_volume');
    volumeRange.addEventListener('input', function() {
        const volumePercentage = Math.round(this.value * 100);
        this.previousElementSibling.textContent = `Default Volume (${volumePercentage}%)`;
    });

    // Delete file buttons
    document.querySelectorAll('.delete-file').forEach(function(button) {
        button.addEventListener('click', function() {
            const fileType = this.getAttribute('data-type');
            showConfirmModal(
                `Are you sure you want to delete the current ${fileType.replace('_', ' ')}?`,
                function() {
                    deleteFile(fileType, button);
                }
            );
        });
    });
    
    function deleteFile(fileType, button) {
        fetch("<?php echo e(route('admin.loading-screen.delete-file')); ?>", {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                file_type: fileType
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const filePreview = button.closest('.current-file');
                filePreview.parentNode.removeChild(filePreview);
            } else {
                alert('Error: ' + data.error);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while deleting the file.');
        });
    }

    // Reset settings
    document.getElementById('reset-settings').addEventListener('click', function() {
        showConfirmModal(
            'Are you sure you want to reset all settings to default values? This cannot be undone.',
            function() {
                document.getElementById('reset-form').submit();
            }
        );
    });

    // Confirmation modal
    const confirmModal = document.getElementById('confirm-modal');
    const confirmMessage = document.getElementById('confirm-message');
    const confirmAction = document.getElementById('confirm-action');
    const cancelAction = document.getElementById('cancel-action');
    const closeModal = document.getElementById('close-modal');
    let onConfirm = null;
    
    function showConfirmModal(message, callback) {
        confirmMessage.textContent = message;
        confirmModal.classList.add('active');
        onConfirm = callback;
    }
    
    function hideConfirmModal() {
        confirmModal.classList.remove('active');
        onConfirm = null;
    }
    
    confirmAction.addEventListener('click', function() {
        if (onConfirm) {
            onConfirm();
        }
        hideConfirmModal();
    });
    
    cancelAction.addEventListener('click', hideConfirmModal);
    closeModal.addEventListener('click', hideConfirmModal);
});
</script>
<?php $__env->stopPush(); ?>

<?php
// Helper function for Blade
function hexToRgb($hex) {
    $hex = ltrim($hex, '#');
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    return "$r,$g,$b";
}
?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/loading-screen/index.blade.php ENDPATH**/ ?>